import CanvasNodeRenderer from './CanvasNodeRenderer.vue';
import { createComponentRenderer } from '@/__tests__/render';
import {
	createCanvasNodeProvide,
	createCanvasProvide,
} from '@/features/workflows/canvas/__tests__/utils';
import { createTestingPinia } from '@pinia/testing';
import { setActivePinia } from 'pinia';
import { CanvasNodeRenderType } from '../../../canvas.types';
import { useWorkflowsStore } from '@/app/stores/workflows.store';
import { createTestWorkflowObject } from '@/__tests__/mocks';

const renderComponent = createComponentRenderer(CanvasNodeRenderer);

beforeEach(() => {
	const pinia = createTestingPinia();
	setActivePinia(pinia);
	const workflowsStore = useWorkflowsStore();
	const workflowObject = createTestWorkflowObject(workflowsStore.workflow);
	workflowsStore.workflowObject = workflowObject;
});

describe('CanvasNodeRenderer', () => {
	it('should render default node correctly', async () => {
		const { getByTestId } = renderComponent({
			global: {
				provide: {
					...createCanvasProvide(),
					...createCanvasNodeProvide(),
				},
			},
		});

		expect(getByTestId('canvas-default-node')).toBeInTheDocument();
	});

	it('should render configuration node correctly', async () => {
		const { getByTestId } = renderComponent({
			global: {
				provide: {
					...createCanvasProvide(),
					...createCanvasNodeProvide({
						data: {
							render: {
								type: CanvasNodeRenderType.Default,
								options: { configuration: true },
							},
						},
					}),
				},
			},
		});

		expect(getByTestId('canvas-configuration-node')).toBeInTheDocument();
	});

	it('should render configurable node correctly', async () => {
		const { getByTestId } = renderComponent({
			global: {
				provide: {
					...createCanvasProvide(),
					...createCanvasNodeProvide({
						data: {
							render: {
								type: CanvasNodeRenderType.Default,
								options: { configurable: true },
							},
						},
					}),
				},
			},
		});

		expect(getByTestId('canvas-configurable-node')).toBeInTheDocument();
	});
});
