import { PromptBuilder } from '@/prompts/builder';

export const instanceUrlPrompt = new PromptBuilder()
	.section(
		'instance_url',
		`The n8n instance base URL is: {instanceUrl}

This URL is essential for webhook nodes and chat triggers as it provides the base URL for:
- Webhook URLs that external services need to call
- Chat trigger URLs for conversational interfaces
- Any node that requires the full instance URL to generate proper callback URLs

When working with webhook or chat trigger nodes, use this URL as the base for constructing proper endpoint URLs.`,
	)
	.build();
